﻿

Get-WmiObject win32_LogicalDisk -Filter "DeviceID='C:'" | % { $FreeSpace = $_.FreeSpace/1GB -as [int] ; $DiskSize = $_.Size/1GB -as [int] }
if ($Freespace -ne $null)
    {
    write-output "DiskSize = $DiskSize, FreeSpace = $Freespace"
    }

"Start: $Freespace"
#Delete Duplicate Instances of Package in CCMCache while keeping the most updated.

#Connect to CCM ComObject
$CMObject = New-Object -ComObject 'UIResource.UIResourceMgr'
$CMCacheObjects = $CMObject.GetCacheInfo()

#Get Packages with more than one instance
$Packages = $CMCacheObjects.GetCacheElements() | Group-Object -Property ContentID | ? {$_.count -gt 1}

#Go through the Duplicate Package and do magic.
ForEach ($Package in $Packages) 
    {
    $PackageID = $Package.Name
    $PackageCount = ($CMCacheObjects.GetCacheElements() | Where-Object {$_.ContentID -eq "$PackageID"}).Count
    write-output "Package: $PackageID has $PackageCount instances"
    $DuplicateContent = $CMCacheObjects.GetCacheElements() | Where-Object {$_.ContentID -eq "$PackageID"} 
    $ContentVersion = $DuplicateContent.ContentVersion | Sort-Object
    $HighestContentID = $ContentVersion | measure -Maximum
    $NewestContent = $DuplicateContent | Where-Object {$_.ContentVersion -eq $HighestContentID.Maximum}
    write-output "Most Updated Package for $PackageID = $($NewestContent.ContentVersion)"
    
    $CMCacheObjects.GetCacheElements() | Where-Object {$_.ContentID -eq $PackageID -and $_.ContentVersion -ne $NewestContent.ContentVersion } | ForEach-Object { 
        $CMCacheObjects.DeleteCacheElement($_.CacheElementID)
        write-output "Deleted: Name: $($_.ContentID)  Version: $($_.ContentVersion)"
        }
}  

# Delete Software Updates item 
$CMCacheObjects.GetCacheElements() | Where-Object { $_.ContentID | Select-String -Pattern '^[\dA-F]{8}-(?:[\dA-F]{4}-){3}[\dA-F]{12}$' }   | ForEach-Object { 
    $CMCacheObjects.DeleteCacheElement($_.CacheElementID)
    write-output "Deleted: Name: $($_.ContentID)  Version: $($_.ContentVersion)" 
}   


#Disable Hibernate
Start-Process C:\windows\System32\powercfg.exe -ArgumentList "-h off"
write-output "Disabled Hibernate"



#Delete c:\drivers

    if (Test-Path -Path "c:\drivers")
        {
        Remove-Item "c:\drivers" -Recurse -Force
        write-output "Starting Delete c:\drivers"
        cmd.exe /c rd c:\drivers /s /q
        write-output "Deleted c:\drivers"
        }
 

#Delete c:\logs

    if (Test-Path -Path "c:\logs")
        {
        Remove-Item "c:\logs" -Recurse -Force
        write-output "Deleted c:\logs"
        }

#Delete C:\Windows\Internet Logs

    if (Test-Path -Path "C:\Windows\Internet Logs")
        {
        write-output "Starting Delete C:\Windows\Internet Logs"
        Remove-Item "C:\Windows\Internet Logs" -Recurse -Force -ErrorAction SilentlyContinue
        write-output "Deleted C:\Windows\Internet Logs"
        }


#Delete c:\Windows\Temp

    if (Test-Path -Path "c:\Windows\Temp")
        {
        Get-ChildItem C:\Windows\Temp\* -Recurse -Force -Verbose -ErrorAction SilentlyContinue | Where-Object { ($_.CreationTime -lt $(Get-Date).AddDays(-7)) } | remove-item -force -Verbose -recurse -ErrorAction SilentlyContinue
        write-output "Deleted c:\Windows\Temp"
        }

#Delete c:\Temp

    if (Test-Path -Path "c:\Temp")
        {
        Get-ChildItem "C:\Temp\*" -Recurse -Force -Verbose -ErrorAction SilentlyContinue | Where-Object { ($_.CreationTime -lt $(Get-Date).AddDays(-7)) } | remove-item -force -Verbose -recurse -ErrorAction SilentlyContinue
        write-output "Deleted c:\Temp "
        }

#Test Search File (Windows.edb)

    $WindowsSearchFilePath = "$($env:ProgramData)\Microsoft\Search\Data\Applications\Windows\Windows.edb"
    $WindowsSearchFileSize = (Get-ItemProperty -Path $WindowsSearchFilePath).Length
    if ($WindowsSearchFileSize -gt 1000000000)
        {
        write-output "Windows.edb = $([math]::Round($WindowsSearchFileSize / 1000000))Mbs - Deleting to clear out Space"
        if ((get-service -Name WSearch).status -ne "Stopped"){Stop-Service -Name WSearch -Verbose}
        if ((get-service -name WSearch).StartType -ne "Disabled"){Set-Service -Name WSearch -StartupType Disabled -Verbose}
        Remove-Item -Path $WindowsSearchFilePath -Verbose
        start-sleep -Seconds 10
        start-process -FilePath "C:\windows\system32\sc.exe" -ArgumentList "config wsearch start=delayed-auto"
        start-sleep -Seconds 10
        if ((get-service -Name WSearch).status -eq "Stopped"){Start-Service -Name WSearch -Verbose}

        }
     Else{write-output "Windows.edb =  $([math]::Round($WindowsSearchFileSize / 1000000))Mbs - Less than 1GB, leaving alone"}

Get-WmiObject win32_LogicalDisk -Filter "DeviceID='C:'" | % { $FreeSpace = $_.FreeSpace/1GB -as [int] ; $DiskSize = $_.Size/1GB -as [int] }
Write-Output "Start: $Freespace End: $Freespace"